/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rtextarea.CaretStyle;
import org.fife.ui.rtextarea.ChangeableHighlightPainter;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaEditorKit;

public class ConfigurableCaret
extends DefaultCaret {
    private static transient Action selectWord = null;
    private static transient Action selectLine = null;
    private transient MouseEvent selectedWordEvent = null;
    private transient Segment seg = new Segment();
    private CaretStyle style;
    private ChangeableHighlightPainter selectionPainter;
    private boolean alwaysVisible;
    private boolean pasteOnMiddleMouseClick;

    public ConfigurableCaret() {
        this(CaretStyle.THICK_VERTICAL_LINE_STYLE);
    }

    public ConfigurableCaret(CaretStyle style) {
        this.setStyle(style);
        this.selectionPainter = new ChangeableHighlightPainter();
        this.pasteOnMiddleMouseClick = true;
    }

    private void adjustCaret(MouseEvent e2) {
        if ((e2.getModifiers() & 1) != 0 && this.getDot() != -1) {
            this.moveCaret(e2);
        } else {
            this.positionCaret(e2);
        }
    }

    private void adjustFocus(boolean inWindow) {
        RTextArea textArea = this.getTextArea();
        if (textArea != null && textArea.isEnabled() && textArea.isRequestFocusEnabled()) {
            if (inWindow) {
                textArea.requestFocusInWindow();
            } else {
                textArea.requestFocus();
            }
        }
    }

    @Override
    protected synchronized void damage(Rectangle r2) {
        if (r2 != null) {
            this.validateWidth(r2);
            this.x = r2.x - 1;
            this.y = r2.y;
            this.width = r2.width + 4;
            this.height = r2.height;
            this.repaint();
        }
    }

    @Override
    public void deinstall(JTextComponent c2) {
        if (!(c2 instanceof RTextArea)) {
            throw new IllegalArgumentException("c must be instance of RTextArea");
        }
        super.deinstall(c2);
        c2.setNavigationFilter(null);
    }

    public boolean getPasteOnMiddleMouseClick() {
        return this.pasteOnMiddleMouseClick;
    }

    protected RTextArea getTextArea() {
        return (RTextArea)this.getComponent();
    }

    public boolean getRoundedSelectionEdges() {
        return ((ChangeableHighlightPainter)this.getSelectionPainter()).getRoundedEdges();
    }

    @Override
    protected Highlighter.HighlightPainter getSelectionPainter() {
        return this.selectionPainter;
    }

    public CaretStyle getStyle() {
        return this.style;
    }

    @Override
    public void install(JTextComponent c2) {
        if (!(c2 instanceof RTextArea)) {
            throw new IllegalArgumentException("c must be instance of RTextArea");
        }
        super.install(c2);
        c2.setNavigationFilter(new FoldAwareNavigationFilter());
    }

    public boolean isAlwaysVisible() {
        return this.alwaysVisible;
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
        if (!e2.isConsumed()) {
            JTextComponent c2;
            RTextArea textArea = this.getTextArea();
            int nclicks = e2.getClickCount();
            if (SwingUtilities.isLeftMouseButton(e2)) {
                if (nclicks > 2) {
                    switch (nclicks %= 2) {
                        case 0: {
                            this.selectWord(e2);
                            this.selectedWordEvent = null;
                            break;
                        }
                        case 1: {
                            Action a2 = null;
                            ActionMap map = textArea.getActionMap();
                            if (map != null) {
                                a2 = map.get("select-line");
                            }
                            if (a2 == null) {
                                if (selectLine == null) {
                                    selectLine = new RTextAreaEditorKit.SelectLineAction();
                                }
                                a2 = selectLine;
                            }
                            a2.actionPerformed(new ActionEvent(textArea, 1001, null, e2.getWhen(), e2.getModifiers()));
                        }
                    }
                }
            } else if (SwingUtilities.isMiddleMouseButton(e2) && this.getPasteOnMiddleMouseClick() && nclicks == 1 && textArea.isEditable() && textArea.isEnabled() && (c2 = (JTextComponent)e2.getSource()) != null) {
                try {
                    Toolkit tk = c2.getToolkit();
                    Clipboard buffer = tk.getSystemSelection();
                    if (buffer != null) {
                        Transferable trans;
                        this.adjustCaret(e2);
                        TransferHandler th = c2.getTransferHandler();
                        if (th != null && (trans = buffer.getContents(null)) != null) {
                            th.importData(c2, trans);
                        }
                        this.adjustFocus(true);
                    } else {
                        textArea.paste();
                    }
                }
                catch (HeadlessException he2) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        JTextComponent c2;
        super.mousePressed(e2);
        if (!e2.isConsumed() && SwingUtilities.isRightMouseButton(e2) && (c2 = this.getComponent()) != null && c2.isEnabled() && c2.isRequestFocusEnabled()) {
            c2.requestFocusInWindow();
        }
    }

    @Override
    public void paint(Graphics g2) {
        if (this.isVisible() || this.alwaysVisible) {
            try {
                RTextArea textArea = this.getTextArea();
                g2.setColor(textArea.getCaretColor());
                TextUI mapper = textArea.getUI();
                Rectangle r2 = mapper.modelToView(textArea, this.getDot());
                this.validateWidth(r2);
                if (this.width > 0 && this.height > 0 && !this.contains(r2.x, r2.y, r2.width, r2.height)) {
                    Rectangle clip = g2.getClipBounds();
                    if (clip != null && !clip.contains(this)) {
                        this.repaint();
                    }
                    this.damage(r2);
                }
                r2.height -= 2;
                switch (this.style) {
                    case BLOCK_STYLE: {
                        Color textAreaBg = textArea.getBackground();
                        if (textAreaBg == null) {
                            textAreaBg = Color.white;
                        }
                        g2.setXORMode(textAreaBg);
                        g2.fillRect(r2.x, r2.y, r2.width, r2.height);
                        break;
                    }
                    case BLOCK_BORDER_STYLE: {
                        g2.drawRect(r2.x, r2.y, r2.width - 1, r2.height);
                        break;
                    }
                    case UNDERLINE_STYLE: {
                        Color textAreaBg = textArea.getBackground();
                        if (textAreaBg == null) {
                            textAreaBg = Color.white;
                        }
                        g2.setXORMode(textAreaBg);
                        int y2 = r2.y + r2.height;
                        g2.drawLine(r2.x, y2, r2.x + r2.width - 1, y2);
                        break;
                    }
                    default: {
                        g2.drawLine(r2.x, r2.y, r2.x, r2.y + r2.height);
                        break;
                    }
                    case THICK_VERTICAL_LINE_STYLE: {
                        g2.drawLine(r2.x, r2.y, r2.x, r2.y + r2.height);
                        ++r2.x;
                        g2.drawLine(r2.x, r2.y, r2.x, r2.y + r2.height);
                        break;
                    }
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }
    }

    private void selectWord(MouseEvent e2) {
        if (this.selectedWordEvent != null && this.selectedWordEvent.getX() == e2.getX() && this.selectedWordEvent.getY() == e2.getY()) {
            return;
        }
        Action a2 = null;
        RTextArea textArea = this.getTextArea();
        ActionMap map = textArea.getActionMap();
        if (map != null) {
            a2 = map.get("select-word");
        }
        if (a2 == null) {
            if (selectWord == null) {
                selectWord = new RTextAreaEditorKit.SelectWordAction();
            }
            a2 = selectWord;
        }
        a2.actionPerformed(new ActionEvent(textArea, 1001, null, e2.getWhen(), e2.getModifiers()));
        this.selectedWordEvent = e2;
    }

    public void setAlwaysVisible(boolean alwaysVisible) {
        if (alwaysVisible != this.alwaysVisible) {
            this.alwaysVisible = alwaysVisible;
            if (!this.isVisible()) {
                this.repaint();
            }
        }
    }

    public void setPasteOnMiddleMouseClick(boolean paste) {
        this.pasteOnMiddleMouseClick = paste;
    }

    public void setRoundedSelectionEdges(boolean rounded) {
        ((ChangeableHighlightPainter)this.getSelectionPainter()).setRoundedEdges(rounded);
    }

    @Override
    public void setSelectionVisible(boolean visible) {
        super.setSelectionVisible(true);
    }

    public void setStyle(CaretStyle style) {
        if (style == null) {
            style = CaretStyle.THICK_VERTICAL_LINE_STYLE;
        }
        if (style != this.style) {
            this.style = style;
            this.repaint();
        }
    }

    private void validateWidth(Rectangle rect) {
        if (rect != null && rect.width <= 1) {
            try {
                RTextArea textArea = this.getTextArea();
                textArea.getDocument().getText(this.getDot(), 1, this.seg);
                Font font = textArea.getFont();
                FontMetrics fm2 = textArea.getFontMetrics(font);
                rect.width = fm2.charWidth(this.seg.array[this.seg.offset]);
                if (rect.width == 0) {
                    rect.width = fm2.charWidth(' ');
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                rect.width = 8;
            }
        }
    }

    private class FoldAwareNavigationFilter
    extends NavigationFilter {
        private FoldAwareNavigationFilter() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setDot(NavigationFilter.FilterBypass fb2, int dot, Position.Bias bias) {
            block11: {
                RSyntaxTextArea rsta;
                RTextArea textArea = ConfigurableCaret.this.getTextArea();
                if (textArea instanceof RSyntaxTextArea && (rsta = (RSyntaxTextArea)ConfigurableCaret.this.getTextArea()).isCodeFoldingEnabled()) {
                    int lastDot = ConfigurableCaret.this.getDot();
                    FoldManager fm2 = rsta.getFoldManager();
                    int line = 0;
                    try {
                        line = textArea.getLineOfOffset(dot);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    if (fm2.isLineHidden(line)) {
                        try {
                            if (dot > lastDot) {
                                int lineCount = textArea.getLineCount();
                                while (++line < lineCount && fm2.isLineHidden(line)) {
                                }
                                if (line >= lineCount) {
                                    UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                                    return;
                                }
                                dot = textArea.getLineStartOffset(line);
                                break block11;
                            }
                            if (dot >= lastDot) break block11;
                            while (--line >= 0 && fm2.isLineHidden(line)) {
                            }
                            if (line >= 0) {
                                dot = textArea.getLineEndOffset(line) - 1;
                            }
                        }
                        catch (Exception e3) {
                            e3.printStackTrace();
                            return;
                        }
                    }
                }
            }
            super.setDot(fb2, dot, bias);
        }

        @Override
        public void moveDot(NavigationFilter.FilterBypass fb2, int dot, Position.Bias bias) {
            super.moveDot(fb2, dot, bias);
        }
    }
}

